package GUI;

import java.awt.Toolkit;

import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import baseClass.Recomendacoes;

/**
 *
 * @author Jonhnanthan Victor
 */
public class MenuPrincipal extends javax.swing.JFrame {

    private static String estabelecimentos, opinioes;
    private static Recomendacoes recomenda;
    private String [][] restaurantes = null;

    @SuppressWarnings("static-access")
	public MenuPrincipal(String restaurantes, String opinioes_users) {
        this.estabelecimentos = restaurantes;
        this.opinioes = opinioes_users;
        try {
            this.recomenda = new Recomendacoes(opinioes_users, restaurantes);
            this.restaurantes = new String[recomenda.getEnderecos().size()][3];
        } catch (Exception ex) {
        	Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, "Problemas com as recomendações!", "Erro interno", 1);
        }
        initComponents();
    }

    /** 
     * Inicia os componentes da janela
     */
    @SuppressWarnings("unchecked")
    private void initComponents() {

        areaTextoBusca = new javax.swing.JTextField();
        bBuscar = new javax.swing.JButton();
        checkPratoFeito = new javax.swing.JCheckBox();
        checkALaCarte = new javax.swing.JCheckBox();
        checkSelfService = new javax.swing.JCheckBox();
        painelResultados = new javax.swing.JPanel();
        painelRolagemTabela = new javax.swing.JScrollPane();
        tabelaDeResultados = new javax.swing.JTable();
        icone = new javax.swing.JLabel();
        barraDeMenu = new javax.swing.JMenuBar();
        menuGarfo = new javax.swing.JMenu();
        menuRecomenda = new javax.swing.JMenuItem();
        menuCadastra = new javax.swing.JMenuItem();
        menuSair = new javax.swing.JMenuItem();
        menuSobre = new javax.swing.JMenu();
        menuDesenvolvedores = new javax.swing.JMenuItem();
        menuDescricao = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Garfo de Ouro - JCK");

        areaTextoBusca.setText("Digite o nome do restaurante que procura ou o tipo (Ex.: bar).");
        areaTextoBusca.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        areaTextoBusca.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                areaTextoBuscaFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                areaTextoBuscaFocusLost(evt);
            }
        });
        areaTextoBusca.getDocument().addDocumentListener(
	     new DocumentListener(){
	         public void insertUpdate(DocumentEvent e){
	             tabelaDeResultados.setModel(new javax.swing.table.DefaultTableModel(
	                     listaRestaurantes(),
	                     new String [] {
	                         "Estabelecimento", "Endereço", "Tipo de Prato"
	                     }
	                 ));
	                 tabelaDeResultados.setVisible(true);
	                 tabelaDeResultados.repaint();
	         }

	         public void removeUpdate(DocumentEvent e){
	             tabelaDeResultados.setModel(new javax.swing.table.DefaultTableModel(
	                     listaRestaurantes(),
	                     new String [] {
	                         "Estabelecimento", "Endereço", "Tipo de Prato"
	                     }
	                 ));
	                 tabelaDeResultados.setVisible(true);
	                 tabelaDeResultados.repaint();
	         }

	         public void changedUpdate(DocumentEvent e){}
	       }
	     );

        bBuscar.setText("Buscar Restaurantes");
        bBuscar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bBuscarActionPerformed(evt);
            }
        });

        checkPratoFeito.setText("Prato Feito");

        checkALaCarte.setText("A la carte");

        checkSelfService.setText("Self-service");

        painelResultados.setBorder(javax.swing.BorderFactory.createTitledBorder("Resultados"));

        tabelaDeResultados.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tabelaDeResultados.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null},
                {null, null, null},
                {null, null, null},
                {null, null, null}
            },
            new String [] {
                "Estabelecimento", "Endereço", "Tipo de Prato"
            }
        ));
        tabelaDeResultados.setAutoscrolls(false);
        tabelaDeResultados.setEnabled(false);
        tabelaDeResultados.setVisible(false);
        painelRolagemTabela.setViewportView(tabelaDeResultados);

        javax.swing.GroupLayout painelResultadosLayout = new javax.swing.GroupLayout(painelResultados);
        painelResultados.setLayout(painelResultadosLayout);
        painelResultadosLayout.setHorizontalGroup(
            painelResultadosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(painelResultadosLayout.createSequentialGroup()
                .addGap(36, 36, 36)
                .addComponent(painelRolagemTabela, javax.swing.GroupLayout.PREFERRED_SIZE, 576, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(101, Short.MAX_VALUE))
        );
        painelResultadosLayout.setVerticalGroup(
            painelResultadosLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(painelResultadosLayout.createSequentialGroup()
                .addComponent(painelRolagemTabela, javax.swing.GroupLayout.PREFERRED_SIZE, 284, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(26, Short.MAX_VALUE))
        );

        icone.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/image3101-v4.png"))); // NOI18N

        barraDeMenu.setPreferredSize(new java.awt.Dimension(20, 21));
        
        menuGarfo.setText("Garfo");
        menuRecomenda.setIcon(new javax.swing.ImageIcon("src/img/recomendacao.png"));
        menuRecomenda.setText("Recomendações");
        menuRecomenda.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                menuRecomendaMousePressed(evt);
            }
        });
        menuGarfo.add(menuRecomenda);
        menuCadastra.setIcon(new javax.swing.ImageIcon("src/img/cadastro.png"));
        menuCadastra.setText("Cadastrar novo usuário");
        menuCadastra.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                menuCadastraMousePressed(evt);
            }
        });
        menuGarfo.add(menuCadastra);
        
        menuSair.setIcon(new javax.swing.ImageIcon("src/img/x.png"));
        menuSair.setText("Sair");
        
        menuSair.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                menuSairMousePressed(evt);
            }
        });
        
        menuGarfo.add(menuSair);

        barraDeMenu.add(menuGarfo);

        menuSobre.setText("Sobre");
        menuDesenvolvedores.setIcon(new javax.swing.ImageIcon("src/img/grupo.png"));
        menuDesenvolvedores.setText("Desenvolvedores");
        menuDesenvolvedores.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                menuDesenvolvedoresMousePressed(evt);
            }
        });
        menuSobre.add(menuDesenvolvedores);
        menuDescricao.setIcon(new javax.swing.ImageIcon("src/img/sobre.png"));
        menuDescricao.setText("Descrição do programa");
        menuDescricao.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                menuDescricaoMousePressed(evt);
            }
        });
        menuSobre.add(menuDescricao);

        barraDeMenu.add(menuSobre);

        setJMenuBar(barraDeMenu);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(22, 22, 22)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(painelResultados, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(areaTextoBusca, javax.swing.GroupLayout.PREFERRED_SIZE, 493, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 62, Short.MAX_VALUE)
                        .addComponent(bBuscar)))
                .addGap(32, 32, 32))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(355, Short.MAX_VALUE)
                .addComponent(icone)
                .addGap(283, 283, 283))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(162, 162, 162)
                .addComponent(checkPratoFeito)
                .addGap(94, 94, 94)
                .addComponent(checkALaCarte)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 103, Short.MAX_VALUE)
                .addComponent(checkSelfService)
                .addGap(123, 123, 123))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(checkPratoFeito)
                    .addComponent(checkSelfService)
                    .addComponent(checkALaCarte))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(areaTextoBusca, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(bBuscar))
                .addGap(18, 18, 18)
                .addComponent(painelResultados, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(29, 29, 29)
                .addComponent(icone)
                .addGap(35, 35, 35))
        );

        pack();
    }

    /**
     * Chama a janela de recomendações ao pressionar o menu recomendações
     * @param evt
     * 		evento do mouse
     */
    private void menuRecomendaMousePressed(java.awt.event.MouseEvent evt) {
        this.dispose();
        new MenuRecomendacoes(estabelecimentos, opinioes);
    }                                          

    /**
     * Chama a janela de cadastro de usuario
     * @param evt
     * 		evento do mouse
     */
    private void menuCadastraMousePressed(java.awt.event.MouseEvent evt) {
        this.dispose();
        new janelaCadastroNome(estabelecimentos, opinioes).setVisible(true);
    }      
    
    /**
     * Sai do programa
     * @param evt
     * 		evento do mouse
     */
    private void menuSairMousePressed(java.awt.event.MouseEvent evt) {                                          
        System.exit(0);
    }

    /**
     * Mostra os desenvolvedores do programa
     * @param evt
     * 		evento do mouse
     */
    private void menuDesenvolvedoresMousePressed(java.awt.event.MouseEvent evt) {                                                 
        JOptionPane.showMessageDialog(null, "-> Jonhnanthan Victor P. Oliveira\n" + "-> Carlos Victor do Nascimento M. Filho\n" + "-> Kaio Cezar da Silva Oliveira " + "\n\n Uiversidade Federal de Campina Grande - 2011.1", "Desenvolvedores", 1);
    }                                                

    /**
     * Mostra uma rápida descrição de um sistem de recomendações
     * @param evt
     * 		evento do mouse
     */
    private void menuDescricaoMousePressed(java.awt.event.MouseEvent evt) {                                           
        JOptionPane.showMessageDialog(null,"Sistemas de recomendação são softwares capazes de lhe ajudar a achar itens\n(produtos, serviços, lugares, ...) que lhe interessam baseados nos seus hábitos e\ngostos. O elemento chave da lógica destes sistemas é, naturalmente, o algoritmo de\nrecomendação. Idealmente, o algoritmo deve produzir recomendações precisas para\nos usuários sem inundá-los com 1000 sugestões todos os dias\n\nUma característica muito interessante desses algoritmos de recomendação é que eles\nsão independentes do problema no qual eles são usados. Podemos usar um mesmo\nalgoritmo para realizar recomendações de livros, músicas, jogos, restaurantes, etc.\nIsso é possível porque eles se baseiam apenas em opiniões dos usuários para realizar\no cálculo das similaridades/dissimilaridades entre essas opiniões e com isso realizar\nas recomendações.\n\nNeste projeto, será implementado um sistema de recomendação de lugares para\nalmoçar em Campina Grande  (CG)  capaz de usar míltiplos algoritmos para\nrecomendar almoços para os usuários. Com essa funcionalidade, o sistema será tanto\nútil para usuários, que descobrirão novos lugares para almoçar, quanto para os alunos\nde computação, que poderão explorar como diferentes algoritmos se comportam ao\ngerar recomendações.", "Descrição", 1);
    }                                          

    /**
     * Ação do botão de busca por restaurantes
     * @param evt
     * 		evento de ação
     */
    private void bBuscarActionPerformed(java.awt.event.ActionEvent evt) {                                        
        tabelaDeResultados.setModel(new javax.swing.table.DefaultTableModel(
            listaRestaurantes(),
            new String [] {
                "Estabelecimento", "Endereço", "Tipo de Prato"
            }
        ));
        tabelaDeResultados.setVisible(true);
        tabelaDeResultados.repaint();
    }                                       

    /**
     * Focus gained da area de texto
     * @param evt
     * 		evento de foco
     */
    private void areaTextoBuscaFocusGained(java.awt.event.FocusEvent evt) {                                           
        if (areaTextoBusca.getText().equalsIgnoreCase("Digite o nome do restaurante que procura ou o tipo (Ex.: bar).")){
            areaTextoBusca.setText("");
        }
    }                                          

    /**
     * Focus lost da area de texto
     * @param evt
     * 		evento de foco
     */
    private void areaTextoBuscaFocusLost(java.awt.event.FocusEvent evt) {                                         
        if (areaTextoBusca.getText().equalsIgnoreCase("")){
            areaTextoBusca.setText("Digite o nome do restaurante que procura ou o tipo (Ex.: bar).");
        }
    }                                        

    /**
     * Cria os arrays com os resutados da busca
     * @return
     * 		array de array para compor a tabela de resultados
     */
    private String[][] listaRestaurantes(){
        restaurantes = new String[recomenda.getEnderecos().size()][3];

        verificaTextoDeBusca();
        if (checkPratoFeito.isSelected() && (areaTextoBusca.getText().isEmpty() || areaTextoBusca.getText().equalsIgnoreCase("Digite o nome do restaurante que procura ou o tipo (Ex.: bar)."))){
            verificaCheckPratoFeito();
        }
        if (checkALaCarte.isSelected() && (areaTextoBusca.getText().isEmpty() || areaTextoBusca.getText().equalsIgnoreCase("Digite o nome do restaurante que procura ou o tipo (Ex.: bar)."))){
            verificaCheckALaCarte();
        }
        if (checkSelfService.isSelected() && (areaTextoBusca.getText().isEmpty() || areaTextoBusca.getText().equalsIgnoreCase("Digite o nome do restaurante que procura ou o tipo (Ex.: bar)."))){
            verificaCheckSelfService();
        }

        if (!checkALaCarte.isSelected() && !checkPratoFeito.isSelected() && !checkSelfService.isSelected() && (areaTextoBusca.getText().isEmpty() || areaTextoBusca.getText().equalsIgnoreCase("Digite o nome do restaurante que procura ou o tipo (Ex.: bar)."))){
            restaurantes = null;
        }
        return restaurantes;
    }

    /**
     * Metodo para verificar a busca do usuario com os filtros existentes
     * @param aVerificar
     * 		string do filtro
     * @param coluna
     * 		coluna na tabela
     */
    private void verificaChecks(String aVerificar, int coluna){
        for (int i = 1; i < recomenda.getEnderecos().size(); i++) {
            String[] restaurante = recomenda.getEnderecos().get(i).split(";");
            if (restaurante[coluna].toLowerCase().equalsIgnoreCase(aVerificar) || restaurante[coluna].toLowerCase().contains(aVerificar)){
                for (int j = 0; j < restaurantes.length; j++) {
                    if (restaurantes[j][0] == null){
                        restaurantes[j] = restaurante;
                        break;
                    }
                }
            }
        }
    }

    /**
     * Organiza os restaurantes apenas pelo tipo do prato
     * @param prato
     * 		tipo do prato
     */
    private void procuraPorTipo(String prato){
        for (int i = 1; i < recomenda.getEnderecos().size(); i++) {
            String[] restaurante = recomenda.getEnderecos().get(i).split(";");
            if (restaurante[2].equalsIgnoreCase(prato) && restaurante[0].toLowerCase().contains(areaTextoBusca.getText().toLowerCase())){
                for (int j = 0; j < restaurantes.length; j++) {
                    if (restaurantes[j][0] == null){
                        restaurantes[j] = restaurante;
                        break;
                    }
                }
            }
        }
    }

    /**
     * Verificador do checkbox prato feito
     */
    private void verificaCheckPratoFeito(){
        verificaChecks("prato feito", 2);
    }

    /**
     * Verificador do checkbox a la carte
     */
    private void verificaCheckALaCarte(){
        verificaChecks("a la carte", 2);
    }

    /**
     * Verificador do checkbox self-service
     */
    private void verificaCheckSelfService(){
        verificaChecks("self-service", 2);
    }

    /**
     * Verificador da area de texto e dos checks
     */
    private void verificaTextoDeBusca() {
        if (!checkALaCarte.isSelected() && !checkPratoFeito.isSelected() && !checkSelfService.isSelected() && !areaTextoBusca.getText().isEmpty()){
            verificaChecks(areaTextoBusca.getText().toLowerCase(), 0);
        }
        if (checkALaCarte.isSelected() && !checkPratoFeito.isSelected() && !checkSelfService.isSelected() && !areaTextoBusca.getText().isEmpty()){
            procuraPorTipo("a la carte");
        }
        if (!checkALaCarte.isSelected() && checkPratoFeito.isSelected() && !checkSelfService.isSelected() && !areaTextoBusca.getText().isEmpty()){
            procuraPorTipo("prato feito");
        }
        if (!checkALaCarte.isSelected() && !checkPratoFeito.isSelected() && checkSelfService.isSelected() && !areaTextoBusca.getText().isEmpty()){
            procuraPorTipo("self-service");
        }
        if (checkALaCarte.isSelected() && checkPratoFeito.isSelected() && !checkSelfService.isSelected() && !areaTextoBusca.getText().isEmpty()){
            procuraPorTipo("a la carte");
            procuraPorTipo("prato feito");
        }
        if (checkALaCarte.isSelected() && !checkPratoFeito.isSelected() && checkSelfService.isSelected() && !areaTextoBusca.getText().isEmpty()){
            procuraPorTipo("a la carte");
            procuraPorTipo("self-service");
        }
        if (!checkALaCarte.isSelected() && checkPratoFeito.isSelected() && checkSelfService.isSelected() && !areaTextoBusca.getText().isEmpty()){
            procuraPorTipo("prato feito");
            procuraPorTipo("self-service");
        }
        if (checkALaCarte.isSelected() && checkPratoFeito.isSelected() && checkSelfService.isSelected() && !areaTextoBusca.getText().isEmpty()){
            procuraPorTipo("a la carte");
            procuraPorTipo("prato feito");
            procuraPorTipo("self-service");
        }
    }

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new MenuPrincipal(estabelecimentos, opinioes).setVisible(true);
            }
        });
    }

    private javax.swing.JTextField areaTextoBusca;
    private javax.swing.JButton bBuscar;
    private javax.swing.JMenuBar barraDeMenu;
    private javax.swing.JCheckBox checkALaCarte;
    private javax.swing.JCheckBox checkPratoFeito;
    private javax.swing.JCheckBox checkSelfService;
    private javax.swing.JLabel icone;
    private javax.swing.JMenuItem menuSair;
    private javax.swing.JMenuItem menuCadastra;
    private javax.swing.JMenuItem menuDescricao;
    private javax.swing.JMenuItem menuDesenvolvedores;
    private javax.swing.JMenu menuGarfo;
    private javax.swing.JMenuItem menuRecomenda;
    private javax.swing.JMenu menuSobre;
    private javax.swing.JPanel painelResultados;
    private javax.swing.JScrollPane painelRolagemTabela;
    private javax.swing.JTable tabelaDeResultados;

}
